/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPackageFormatException;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchSolarisPackageVersion;

public class OipchSolarisPackage
extends OipchPackage {
    private String m_sDisplayName;
    private String m_sArch;
    private String m_sCategory;
    private String m_sDescription;
    private Date m_oInstallDate;
    static final String INSTDATE_FORMAT = "MMM dd yyyy HH:mm";
    private String m_sPStamp;
    private String m_sVendor;
    private String m_sBaseDir;
    private int m_iInstallStatus = 2;
    private OipchSolarisPackageVersion m_oVersion;
    public static final int COMPLETE_INSTALL = 0;
    public static final int PARTIAL_INSTALL = 1;
    public static final int UNKNOWN_INSTALL = 2;
    static final String COMPLETE_INSTALL_STR = "completely installed";
    static final String PARTIAL_INSTALL_STR = "partially installed";

    public int compare(Object other) {
        int iResult = 8;
        if (other != null) {
            if (other == this) {
                iResult = 1;
            } else if (other instanceof OipchSolarisPackage) {
                OipchSolarisPackage pkg = (OipchSolarisPackage)other;
                if (super.getName().equals(pkg.getName())) {
                    OipchSolarisPackageVersion spv1 = pkg.getVersion();
                    OipchSolarisPackageVersion spv2 = pkg.getVersion();
                    iResult = spv1 != null && spv2 != null ? spv1.compare(spv2) : 1;
                }
            }
        }
        return iResult;
    }

    public boolean isCompatible(Object obj) {
        return true;
    }

    public String getDisplayName() {
        if (this.m_sDisplayName != null) {
            if (this.m_oVersion != null) {
                Object[] args = new String[]{this.m_sDisplayName, this.getName(), this.m_oVersion.getDisplayName()};
                return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OIPCH0002", (Object[])args);
            }
            Object[] args = new String[]{this.m_sDisplayName, this.getName()};
            return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OIPCH0003", (Object[])args);
        }
        if (this.m_oVersion != null) {
            Object[] args = new String[]{this.getName(), this.m_oVersion.getDisplayName()};
            return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OIPCH0004", (Object[])args);
        }
        return this.getName();
    }

    void setExternalName(String name) {
        this.m_sDisplayName = name;
    }

    void setVendor(String vendor) {
        this.m_sVendor = vendor;
    }

    void setDescription(String desc) {
        this.m_sDescription = desc;
    }

    void setBaseDirectory(String base) {
        this.m_sBaseDir = base;
    }

    void setCategory(String category) {
        this.m_sCategory = category;
    }

    void setArch(String arch) {
        this.m_sArch = arch;
    }

    void setInstallDate(Date date) {
        this.m_oInstallDate = date;
    }

    void setInstallDate(String sDate) throws ParseException {
        SimpleDateFormat sdt = new SimpleDateFormat(INSTDATE_FORMAT);
        Date date = sdt.parse(sDate);
        this.setInstallDate(date);
    }

    void setInstallStatus(int status) {
        this.m_iInstallStatus = status;
    }

    void setInstallStatus(String sStatus) throws OipchIncorrectPackageFormatException {
        if (sStatus.equalsIgnoreCase(COMPLETE_INSTALL_STR)) {
            this.setInstallStatus(0);
        } else if (sStatus.equalsIgnoreCase(PARTIAL_INSTALL_STR)) {
            this.setInstallStatus(1);
        } else {
            Object[] args = new String[]{sStatus};
            throw new OipchIncorrectPackageFormatException("OUI-11103", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11103", (Object[])args));
        }
    }

    void setPStamp(String pstamp) {
        this.m_sPStamp = pstamp;
    }

    void setVersion(OipchSolarisPackageVersion version) {
        this.m_oVersion = version;
    }

    public String getExternalName() {
        return this.m_sDisplayName;
    }

    public String getVendor() {
        return this.m_sVendor;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public String getBaseDirectory() {
        return this.m_sBaseDir;
    }

    public Date getInstallDate() {
        return this.m_oInstallDate;
    }

    public String getArch() {
        return this.m_sArch;
    }

    public String getCategory() {
        return this.m_sCategory;
    }

    public int getInstallStatus() {
        return this.m_iInstallStatus;
    }

    public String getPStamp() {
        return this.m_sPStamp;
    }

    public OipchSolarisPackageVersion getVersion() {
        return this.m_oVersion;
    }

    public boolean equals(Object obj) {
        return this.compare(obj) == 1;
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    void setVersion(String ver) {
        int idx = ver.indexOf(44);
        if (idx == -1) {
            this.setVersion(new OipchSolarisPackageVersion(ver, null));
        } else {
            String sBase = ver.substring(0, idx);
            if ((idx = ver.indexOf(61, idx)) == -1) {
                this.setVersion(new OipchSolarisPackageVersion(sBase, null));
            } else {
                String sRev = ver.substring(idx + 1);
                this.setVersion(new OipchSolarisPackageVersion(sBase, sRev));
            }
        }
    }

    public void setProperty(String sPropName, String sValue) throws OipchIncorrectPackageFormatException {
        if (sPropName.equals("NAME") || sPropName.equals("VAR")) {
            this.setName(sValue);
        } else if (sPropName.equals("VERSION")) {
            this.setVersion(sValue);
        } else if (sPropName.equals("ARCHITECTURE")) {
            this.setArch(sValue);
        } else if (sPropName.equals("BASE_DIR")) {
            this.setBaseDirectory(sValue);
        } else if (sPropName.equals("INSTDATE")) {
            try {
                this.setInstallDate(sValue);
            }
            catch (ParseException e) {
                Object[] args = new String[]{sValue, e.getMessage(), INSTDATE_FORMAT};
                throw new OipchIncorrectPackageFormatException("OUI-11102", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11102", (Object[])args), e);
            }
        } else if (sPropName.equals("STATUS")) {
            this.setInstallStatus(sValue);
        } else if (sPropName.equals("DESC")) {
            this.setDescription(sValue);
        } else if (sPropName.equals("EXTERNALNAME")) {
            this.setExternalName(sValue);
        } else if (sPropName.equals("CATEGORY")) {
            this.setCategory(sValue);
        } else {
            Object[] args = new String[]{sPropName, sValue};
            throw new OipchIncorrectPackageFormatException("OUI-11104", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11104", (Object[])args));
        }
    }
}

